package com.supermanhamuerto.rubik;

public class MoveRotateZLeft extends MoveRotate
{

    public MoveRotateZLeft(int outerLayer, int innerLayer)
    {
        super(Axis.Z, Rotation.CLOCKWISE, outerLayer, innerLayer);
    }
    
    /**
     * Rotate the top layer of the cube <- (this direction)
     */
    @Override
    public void apply( Cube c )
    {
        Color tmp; 
        // perform rotation on top layer
        tmp = c.getColor(1, 2, outerLayer);
        c.setColor(1, 2, outerLayer, c.getColor(2, 2, outerLayer));
        c.setColor(2, 2, outerLayer, c.getColor(2, 1, outerLayer));
        c.setColor(2, 1, outerLayer, c.getColor(1, 1, outerLayer));
        c.setColor(1, 1, outerLayer, tmp);
        // perform rotation on layer 2
        tmp = c.getColor(1, 3, innerLayer);
        c.setColor(1, 3, innerLayer, c.getColor(3, 2, innerLayer));
        c.setColor(3, 2, innerLayer, c.getColor(2, 0, innerLayer));
        c.setColor(2, 0, innerLayer, c.getColor(0, 1, innerLayer));
        c.setColor(0, 1, innerLayer, tmp);
        tmp = c.getColor(2, 3, innerLayer);
        c.setColor(2, 3, innerLayer, c.getColor(3, 1, innerLayer));
        c.setColor(3, 1, innerLayer, c.getColor(1, 0, innerLayer));
        c.setColor(1, 0, innerLayer, c.getColor(0, 2, innerLayer));
        c.setColor(0, 2, innerLayer, tmp );
    } // apply

}
