package com.supermanhamuerto.rubik;

public class MoveRotate implements Movement
{
    private static final String nl = System.getProperty("line.separator");
    private final Axis axis;
    private final Rotation rotation;
    protected int outerLayer;
    protected int innerLayer;

    public MoveRotate( Axis axis, Rotation rotation, int outerLayer, int innerLayer )
    {
        this.axis = axis;
        this.rotation = rotation;
        this.outerLayer = outerLayer;
        this.innerLayer = innerLayer;
    } // constructor
    
    public int getOuterLayer()
    {
        return this.outerLayer;
    }

    public int getInnerLayer()
    {
        return this.innerLayer;
    }
    
    public Axis getAxis()
    {
        return this.axis;
    }
    
    public Rotation getRotation()
    {
        return this.rotation;
    }
    
    /**
     * Returns just the opposite movement to 
     * this movement, i.e. the movement that
     * undoes this movement. 
     * 
     */
    @Override
    public Movement getOposite()
    {
        if( rotation == Rotation.CLOCKWISE )
            return new MoveRotate( axis, 
                            Rotation.COUNTERCLOCKWISE, 
                            outerLayer, 
                            innerLayer );
        else
            return new MoveRotate( axis, 
                    Rotation.CLOCKWISE, 
                    outerLayer, 
                    innerLayer );
            
    }
    
    @Override
    public String toString()
    {
        StringBuilder out = new StringBuilder();
        
        switch( axis )
        {
        case X:
          if( outerLayer == 0 )
          {
              if( rotation == Rotation.CLOCKWISE )
              {
                  out.append("+---+---+");out.append(nl);
                  out.append("| | |   |");out.append(nl);
                  out.append("+ | +---+");out.append(nl);
                  out.append("| v |   |");out.append(nl);
                  out.append("+---+---+");out.append(nl);
              }
              else
              {//COUNTERCLOCKWISE
                  out.append("+---+---+");out.append(nl);
                  out.append("| ^ |   |");out.append(nl);
                  out.append("+ | +---+");out.append(nl);
                  out.append("| | |   |");out.append(nl);
                  out.append("+---+---+");out.append(nl);
              } // rotation
          }
          else
          {
              if( rotation == Rotation.CLOCKWISE )
              {
                  out.append("+---+---+");out.append(nl);
                  out.append("|   | | |");out.append(nl);
                  out.append("+---+ | +");out.append(nl);
                  out.append("|   | v |");out.append(nl);
                  out.append("+---+---+");out.append(nl);
              }
              else
              {
                  out.append("+---+---+");out.append(nl);
                  out.append("|   | ^ |");out.append(nl);
                  out.append("+---+ | +");out.append(nl);
                  out.append("|   | | |");out.append(nl);
                  out.append("+---+---+");out.append(nl);
              } // rotation
          } // outerLayer == 0
          break;
        case Y:
            if( outerLayer == 0 )
            {
                if( rotation == Rotation.CLOCKWISE )
                {
                    out.append( "    +---+---+");out.append(nl);
                    out.append( "   / --->  /");out.append(nl);
                    out.append( "   -------  ");out.append(nl);
                    out.append( " /   /   /  ");out.append(nl);
                    out.append( "+---+---+   ");out.append(nl);                    
                }
                else
                {
                    out.append( "    +---+---+");out.append(nl);
                    out.append( "   / <---  /");out.append(nl);
                    out.append( "   -------  ");out.append(nl);
                    out.append( " /   /   /  ");out.append(nl);
                    out.append( "+---+---+   ");out.append(nl);                   
                } // rotation
            }
            else
            {
                if( rotation == Rotation.CLOCKWISE )
                {
                    out.append( "    +---+---+");out.append(nl);
                    out.append( "   /   /   /");out.append(nl);
                    out.append( "   -------  ");out.append(nl);
                    out.append( " / --->  /  ");out.append(nl);
                    out.append( "+---+---+   ");out.append(nl);                    
                }
                else
                {
                    out.append( "    +---+---+");out.append(nl);
                    out.append( "   /   /   /");out.append(nl);
                    out.append( "   -------  ");out.append(nl);
                    out.append( " / <---  /  ");out.append(nl);
                    out.append( "+---+---+   ");out.append(nl);                    
                } // rotation               
            } // outerLayer
            break;
        case Z:
            if( outerLayer == 0 )
            {
                if( rotation == Rotation.CLOCKWISE )
                {
                    out.append( "+---+---+");out.append(nl);
                    out.append( "| <---  |");out.append(nl);
                    out.append( "+---+---+");out.append(nl);
                    out.append( "|   |   |");out.append(nl);
                    out.append( "+---+---+");out.append(nl);                    
                }
                else
                {
                    out.append( "+---+---+");out.append(nl);
                    out.append( "| --->  |");out.append(nl);
                    out.append( "+---+---+");out.append(nl);
                    out.append( "|   |   |");out.append(nl);
                    out.append( "+---+---+");out.append(nl);
                } // rotation
            }
            else
            {
                if( rotation == Rotation.CLOCKWISE )
                {
                    out.append( "+---+---+");out.append(nl);
                    out.append( "|   |   |");out.append(nl);
                    out.append( "+---+---+");out.append(nl);
                    out.append( "| <---  |");out.append(nl);
                    out.append( "+---+---+");out.append(nl);
                }
                else
                {
                    out.append( "+---+---+");out.append(nl);
                    out.append( "|   |   |");out.append(nl);
                    out.append( "+---+---+");out.append(nl);
                    out.append( "| --->  |");out.append(nl);
                    out.append( "+---+---+");out.append(nl);
                } // rotation               
            } // outerLayer            
            break;
        default:
            out.append("ERROR IN MOVEMENT");
        } // switch
        
        return out.toString();
    } // toString
    
    @Override
    public void apply( Cube c )
    {
        // do nothing, this class is 
        // for be inherited
    }
    
    /**
     * create a single number with the joining 
     * of the four that characterize the object,
     * because all this numbers are < 10
     * 
     */
    @Override
    public int hashCode()
    {
        return axis.ordinal() 
                + (rotation.ordinal() * 10) 
                + (outerLayer * 100) 
                + (innerLayer*1000);
    }

    @Override
    public boolean equals(Object obj)
    {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        MoveRotate other = (MoveRotate) obj;
        
        return this.getAxis() == other.getAxis() 
            && this.getRotation() == other.getRotation()
            && this.getInnerLayer() == other.getInnerLayer()
            && this.getOuterLayer() == other.getOuterLayer();
    } // equals
    
}