package com.supermanhamuerto.rubik;

public class CubeLoader
{
    /**
     * Loads the cube from strings into the application. 
     * 
     * How to read the cube:
     * 
     *      1. put the rubik cube in front of you.
     *      2. read the colors of the top layer, 
     *         as if you were reading a book or a novel.
     *         If you have this:
     *         +---+
     *         |R|G|
     *         |Y|W|
     *         +---+
     *         You must enter the string "rgyw"
     *      3. Now read the colors of the face in front of you
     *      4. continue reading the colors of the face behind the cube
     *      5. and then the colors in the face in the back of the cube
     *      6. next, the rigth (your right, not the cube's) colors
     *      7. and finnally, the colors of the left face
     *      
     * @param c
     * @param face1
     * @param face2
     * @param face3
     * @param face4
     * @param face5
     * @param face6
     */
    public void setFaces( Cube c, String face1, String face2, String face3, String face4, String face5, String face6 )
    {
        c.setColor(1, 1, 0, strToColor(face1.charAt(0)));
        c.setColor(2, 1, 0, strToColor(face1.charAt(1)));
        c.setColor(1, 2, 0, strToColor(face1.charAt(2)));
        c.setColor(2, 2, 0, strToColor(face1.charAt(3)));

        c.setColor(1, 3, 1, strToColor(face2.charAt(0)));
        c.setColor(2, 3, 1, strToColor(face2.charAt(1)));
        c.setColor(1, 3, 2, strToColor(face2.charAt(2)));
        c.setColor(2, 3, 2, strToColor(face2.charAt(3)));

        c.setColor(1, 2, 3, strToColor(face3.charAt(0)));
        c.setColor(2, 2, 3, strToColor(face3.charAt(1)));
        c.setColor(1, 1, 3, strToColor(face3.charAt(2)));
        c.setColor(2, 1, 3, strToColor(face3.charAt(3)));

        c.setColor(1, 0, 2, strToColor(face4.charAt(0)));
        c.setColor(2, 0, 2, strToColor(face4.charAt(1)));
        c.setColor(1, 0, 1, strToColor(face4.charAt(2)));
        c.setColor(2, 0, 1, strToColor(face4.charAt(3)));

        c.setColor(3, 2, 1, strToColor(face5.charAt(0)));
        c.setColor(3, 1, 1, strToColor(face5.charAt(1)));
        c.setColor(3, 2, 2, strToColor(face5.charAt(2)));
        c.setColor(3, 1, 2, strToColor(face5.charAt(3)));

        c.setColor(0, 1, 1, strToColor(face6.charAt(0)));
        c.setColor(0, 2, 1, strToColor(face6.charAt(1)));
        c.setColor(0, 1, 2, strToColor(face6.charAt(2)));
        c.setColor(0, 2, 2, strToColor(face6.charAt(3)));

    } // setFaces
    
    public Color strToColor( char car )
    {
        if( 'R' == car || 'r' == car ) return Color.RED;
        if( 'Y' == car || 'y' == car ) return Color.YELLOW;
        if( 'B' == car || 'b' == car ) return Color.BLUE;
        if( 'V' == car || 'v' == car ) return Color.VIOLET;
        if( 'W' == car || 'w' == car ) return Color.WHITE;
        if( 'G' == car || 'g' == car ) return Color.GREEN;
        return Color.NOCOLOR;
    } // strToColor
}
