/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons.rpc.impl;

import oracle.ons.Notification;
import oracle.ons.Publisher;
import oracle.ons.rpc.RpcRequest;

final class RpcRequestImpl
implements RpcRequest {
    private String broadcastId;
    private String directSource;
    private String traceRoute;
    private String logicalAddress;
    private byte[] argsBytes;
    private Publisher publisher;
    private boolean finalResponseSent;

    RpcRequestImpl(String broadcastId, String directSource, String traceRoute, String logicalAddress, byte[] argsBytes, Publisher publisher) {
        this.broadcastId = broadcastId;
        this.directSource = directSource;
        this.traceRoute = traceRoute;
        this.logicalAddress = logicalAddress;
        this.argsBytes = argsBytes;
        this.publisher = publisher;
        this.finalResponseSent = false;
    }

    @Override
    public byte[] getArgBytes() {
        return this.argsBytes;
    }

    @Override
    public void sendResult(byte[] response, boolean success) {
        boolean isFinalResponse = true;
        this.sendResponse(response, isFinalResponse, success);
    }

    @Override
    public void sendResponse(byte[] responseBytes, boolean isFinalResponse, boolean success) {
        if (this.finalResponseSent) {
            return;
        }
        Notification response = new Notification("ONS_RPC_RESPONSE", "", "", responseBytes);
        response.put("ONSbroadcastID", this.broadcastId);
        response.put("DirectRoute", this.directSource);
        response.put("BackRoute", this.traceRoute);
        response.put("DirectSource", this.logicalAddress);
        if (isFinalResponse) {
            response.putInternalProperty("Result", success ? "success" : "failure");
            this.finalResponseSent = true;
        } else {
            response.putInternalProperty("Result", "partial");
        }
        this.publisher.publish(response);
    }

    boolean isDone() {
        return this.finalResponseSent;
    }
}

