/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.InterruptedIOException;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public final class TimeoutInterruptHandler {
    static Timer interruptTimer = new Timer("InterruptTimer", true);
    static ConcurrentHashMap<Thread, InterruptTask> outboundTimerTasksHash = new ConcurrentHashMap();
    static ConcurrentHashMap<Thread, InterruptTask> soTimerTasksHash = new ConcurrentHashMap();

    public static Timer getTimer() {
        return interruptTimer;
    }

    public static InterruptTask scheduleInterrupt(InterruptTaskType interruptTaskType, int n2, Thread thread, SocketChannel socketChannel) {
        Map<Thread, InterruptTask> map = TimeoutInterruptHandler.getMap(interruptTaskType);
        if (map.get(thread) != null) {
            throw new IllegalStateException("Interrupt task is already scheduled for the thread " + thread + " and the type " + (Object)((Object)interruptTaskType));
        }
        if (n2 <= 0) {
            return null;
        }
        InterruptTask interruptTask = new InterruptTask(thread, n2, socketChannel);
        interruptTimer.schedule((TimerTask)interruptTask, n2);
        map.put(Thread.currentThread(), interruptTask);
        return interruptTask;
    }

    public static InterruptTask scheduleInterrupt(InterruptTaskType interruptTaskType, int n2, Thread thread) {
        return TimeoutInterruptHandler.scheduleInterrupt(interruptTaskType, n2, thread, null);
    }

    public static InterruptTask cancelInterrupt(InterruptTaskType interruptTaskType, Thread thread) {
        Map<Thread, InterruptTask> map = TimeoutInterruptHandler.getMap(interruptTaskType);
        InterruptTask interruptTask = map.remove(thread);
        if (interruptTask != null) {
            interruptTask.cancel();
            interruptTimer.purge();
        }
        return interruptTask;
    }

    public static boolean isInterruptScheduled(InterruptTaskType interruptTaskType, Thread thread) {
        Map<Thread, InterruptTask> map = TimeoutInterruptHandler.getMap(interruptTaskType);
        return map.get(thread) != null;
    }

    public static void resetTimer(InterruptTaskType interruptTaskType, Thread thread) {
        Map<Thread, InterruptTask> map = TimeoutInterruptHandler.getMap(interruptTaskType);
        InterruptTask interruptTask = TimeoutInterruptHandler.cancelInterrupt(interruptTaskType, thread);
        if (interruptTask != null) {
            if (interruptTask.isInterrupted) {
                Thread.interrupted();
            }
            TimeoutInterruptHandler.scheduleInterrupt(interruptTaskType, interruptTask.time, thread);
        }
    }

    private static Map<Thread, InterruptTask> getMap(InterruptTaskType interruptTaskType) {
        if (interruptTaskType.equals((Object)InterruptTaskType.OUTBOUND_TIMEOUT)) {
            return outboundTimerTasksHash;
        }
        return soTimerTasksHash;
    }

    public static void stopTimer() {
        interruptTimer.cancel();
    }

    public static TimerTask scheduleTask(Runnable runnable, long l2) {
        TimerPurgingTask timerPurgingTask = new TimerPurgingTask(runnable);
        interruptTimer.schedule((TimerTask)timerPurgingTask, l2);
        return timerPurgingTask;
    }

    public static class IOReadTimeoutException
    extends InterruptedIOException {
        private static final long serialVersionUID = 1L;

        IOReadTimeoutException(String string) {
            super(string);
        }
    }

    private static final class TimerPurgingTask
    extends TimerTask {
        private final Runnable runnableTask;
        private boolean isPurged = false;

        private TimerPurgingTask(Runnable runnable) {
            this.runnableTask = runnable;
        }

        @Override
        public void run() {
            this.runnableTask.run();
        }

        @Override
        public boolean cancel() {
            boolean bl = super.cancel();
            if (!this.isPurged) {
                interruptTimer.purge();
                this.isPurged = true;
            }
            return bl;
        }
    }

    public static class InterruptTask
    extends TimerTask {
        private final Thread threadTobeInteruppted;
        private boolean isInterrupted = false;
        private final int time;
        private final SocketChannel socketChannel;

        public InterruptTask(Thread thread, int n2) {
            this.threadTobeInteruppted = thread;
            this.time = n2;
            this.socketChannel = null;
        }

        public InterruptTask(Thread thread, int n2, SocketChannel socketChannel) {
            this.threadTobeInteruppted = thread;
            this.time = n2;
            this.socketChannel = socketChannel;
        }

        public boolean isInterrupted() {
            return this.isInterrupted;
        }

        private void sendAttentionMarker() {
            if (this.socketChannel == null) {
                return;
            }
            try {
                this.socketChannel.socket().sendUrgentData(33);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            this.isInterrupted = true;
            this.sendAttentionMarker();
            this.threadTobeInteruppted.interrupt();
        }
    }

    public static enum InterruptTaskType {
        SO_TIMEOUT,
        OUTBOUND_TIMEOUT;

    }
}

